//  
//  lang.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections;
using System.Text;
using System.IO;

namespace LFSLapper
{
    public class lang
    {
        GLDebug.Debug myDebug;
        private Hashtable langTable = new Hashtable();
        private string paramString = "";
        private string[] args = new string[100];
        public lang( GLDebug.Debug pmyDebug )
        {

            this.myDebug = pmyDebug;

        }
        public string replaceLangStr( string lang, string str ){
            string strResult = "";
            string strSave = "";
            int idx = 0;
            int start;
            string tempStr = "";
            string id = "";
            Hashtable enLang;
            Hashtable currLang;

            enLang = (Hashtable)langTable[ "en" ];
            currLang = (Hashtable)langTable[ lang ];
            if (enLang == null)
                return "Lang : en (id " + id + " notfound)";
            strSave = str;
            while (true)
            {
                idx = str.IndexOf("%{");
                if (idx != -1)
                {
                    if( idx != 0 )
                        strResult += str.Substring(0, idx);
                    start = idx + 2;
                    str = str.Substring(idx + 2);
                    idx = str.IndexOf("}%");
                    if (idx == -1)
                    {
                        strResult += str;
                        return strResult;
                    }
                    id = str.Substring(0, idx);
                    if (enLang.ContainsKey(id))
                    {
                        tempStr = (string)enLang[id];
                    }
                    else
                    {
                        tempStr = "(id " + id + " notfound)";
                    }
                    if (currLang != null && currLang.Contains(id))
                    {
                        tempStr = (string)currLang[id];
                    }
                    strResult += tempStr;
                    str = str.Substring(idx + 2);
                    continue;
                }
                strResult += str;
                break;
            }
            return strResult;
        }
        public void AddItem( string idLang, string idItem, string str ){

            if (!langTable.Contains(idLang))
                langTable[idLang] = new Hashtable();

            Hashtable currLang = (Hashtable)langTable[idLang];

            currLang[ idItem ] = str;
        }
        public void setParmsTranslate(string pstr, ArrayList pargs)
        {
            paramString = pstr;
            for (int i = 0; i < pargs.Count; i++)
                args[i] = pargs[i].ToString();

        }
        public void setParmsTranslate(string pstr, params String[] pargs)
        {
            paramString = pstr;
            for (int i = 0; i < pargs.Length; i++)
                args[i] = pargs[i].ToString();

        }
        public string replaceParmsLangStr(string idLang)
        {
            string tmpStr = replaceLangStr(idLang, paramString);
            return string.Format( tmpStr , args);
        }
        public string doParmsTranslation(string idLang, string pstr, params String[] pargs)
        {
            setParmsTranslate(pstr, pargs);
            return (replaceParmsLangStr(idLang));
        }
        public string[] getAllLang()
        {
            ArrayList arRet = new ArrayList();

            foreach (DictionaryEntry de in langTable)
            {
                arRet.Add(de.Key.ToString());
            }
            string[] ret = arRet.ToArray(Type.GetType("System.String")) as string[];
            return ret;
        }
    }
}
